/******************************************************************************
Ootake
EPSG,ADPCM,CDDAꂼDirectSoundobt@pӂ邱ƂŁAeTEh̃_C
  i~bNWőɎAコB
Eobt@̃ubNSɕ邱ƂŁA̒xƃp\Rւׂ̕y
  B
E}X^[{[̒100%Ƃî݂ƂB()
E̍Đɂ̓EFCg邱ƂŁAĐɋNmCYB
E͍ĐTv[g44.1KHzŒƂB(CD-DAĐ̑xAbv̂)
ENeBJZNV͕KvȂ(݂ɍs킯ł͂Ȃ)悤
  ̂ŁAȗBv1.09

Copyright(C)2006-2021 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[APU.c]
		`ot܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <math.h>
#include "APU.h"
#include "AudioOut.h"
#include "PSG.h"
#include "ADPCM.h"
#include "CDROM.h"
#include "App.h"
#include "MainBoard.h"
#include "PRINTF.h"


static Sint32			_SampleRate = 44100;	// [Hz]
static Sint32			_BufSize = 1664; //v2.94XVB̒lDirectXňxɍĐ(])TCYBSy邽߁xȂ邽߂ɁȂ傫AOUT_BUFFERRATE(4ɂ){̃obt@pӂDirectXɂ̕nɂBP[sample]
static Sint32			_BufSizeAll = 1664*AOUT_BUFFERRATE; //v2.94XVBKitaoǉBSẴubÑobt@eʁB̂ߗpӁBv0.92B
static Sint32			_nSamplesPerFrame;

static Sint16*			_pMixBuf1 = NULL; //KitaoXVBPSGpobt@BPSG,ADPCM,CDDAꂼɃobt@pӂă_Ci~bNWőɎB(啝Abv)
static Sint16*			_pMixBuf2 = NULL; //KitaoXVBADPCMpobt@
static Sint16*			_pMixBuf3 = NULL; //KitaoXVBCDDApobt@
static volatile Sint32	_MixBufPos1; //KitaoXVBPSGBPSG̏ꍇA^C~O邽߂ɃCXbhQƂ̂volatileɁB
static volatile Sint32	_MixBufPos2; //KitaoXVBADPCMBADPCMׂ₩ȃ^C~OKvƂ\tg(hSXC[pY`̃hȂ)̂ŁAPSGƓl̏Bv2.18
static Sint32			_MixBufPos3; //KitaoXVBCDDA
static volatile double	_MixBufEndPos1; //KitaoXVBPSG
static volatile double	_MixBufEndPos2; //KitaoXVBADPCM
static Sint32			_MixBufEndPos3; //KitaoXVBCDDABCDDAׂ͍^C~OKv̂ŐZOKBv2.29XV
static volatile Sint32	_NextPlayPos1; //KitaoǉBPSGpBɍĐ(DirectSoundɓ])ʒuB0BufSize*nB
static volatile Sint32	_NextPlayPos2; //KitaoǉBADPCMp
static Sint32			_NextPlayPos3; //KitaoǉBCDDAp
static volatile BOOL	_bPosStop1 = FALSE; //KitaoǉBobt@t̂ƂTRUEɁB
static volatile BOOL	_bPosStop2 = FALSE; //KitaoǉBobt@t̂ƂTRUEɁB

static Uint32		_ClockCount;
static Sint32		_Volume; // APU volume (0-65535) KitaoXVBD̂߂ł̓{[_Ê݂sB

static HANDLE	_hMutex; //v2.18
static volatile BOOL	_bApuBusy = FALSE; //Kitaoǉ


/*-----------------------------------------------------------------------------
	[callback_mixer]
		̊֐ AudioInterface ̃R[obNƂēo^B
	̊֐Ăяo邽тɁAꂼ̃`l̏o͂
	Sint16 ɕϊ pDst ɏoB`l̏óiTvj
	Ȃꍇ́A̕[B
-----------------------------------------------------------------------------*/
//KitaoǋLFAudioOut.c̉ĐpXbhŎsB
static void
callback_mixer(
	int 			ch,					// KitaoǉB1=PSG, 2=ADPCM, 3=CDDA
	Sint16*			pDst,				// o͐obt@ //KitaoXVBe`lpobt@ɕSint16ɁB
	Sint32			nSamples)			// oTv 
{
	Sint32			n, n2;
	Sint32			a;
	Sint16*			pSrc; //KitaoXVBSint16ɁB
	int				i;

	_bApuBusy = TRUE;

	WaitForSingleObject(_hMutex, INFINITE); //CXbhɋLϐ\̂ŁArBv2.18
	switch (ch)
	{
		case 1: //PSG
			pSrc = _pMixBuf1 + (_NextPlayPos1 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if ((!_bPosStop1)&&(_MixBufPos1 >= _NextPlayPos1))
				a = _MixBufPos1 - _NextPlayPos1;
			else
				a = _BufSizeAll - _NextPlayPos1 + _MixBufPos1;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n);
				_MixBufPos1 += n;
				if (_MixBufPos1 >= _BufSizeAll)
					_MixBufPos1 -= _BufSizeAll;
				_MixBufEndPos1 = _MixBufPos1;
			}
			break;
			
		case 2: //ADPCM
			pSrc = _pMixBuf2 + (_NextPlayPos2 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if ((!_bPosStop2)&&(_MixBufPos2 >= _NextPlayPos2))
				a = _MixBufPos2 - _NextPlayPos2;
			else
				a = _BufSizeAll - _NextPlayPos2 + _MixBufPos2;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				ADPCM_Mix(_pMixBuf2+(_MixBufPos2 << 1), n);
				_MixBufPos2 += n;
				if (_MixBufPos2 >= _BufSizeAll)
					_MixBufPos2 -= _BufSizeAll;
				_MixBufEndPos2 = _MixBufPos2;
			}
			break;
		
		case 3: //CDDA
			pSrc = _pMixBuf3 + (_NextPlayPos3 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if (_MixBufPos3 >= _NextPlayPos3)
				a = _MixBufPos3 - _NextPlayPos3;
			else
				a = _BufSizeAll - _NextPlayPos3 + _MixBufPos3;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				CDROM_Mix(_pMixBuf3+(_MixBufPos3 << 1), n);
				_MixBufPos3 += n;
				if (_MixBufPos3 >= _BufSizeAll)
					_MixBufPos3 -= _BufSizeAll;
				_MixBufEndPos3 = _MixBufPos3;
			}
			break;
		default:
			pSrc = 0; //RpCG[
	}
	ReleaseMutex(_hMutex); //v2.18Br

	//DirectSound̃obt@ɏ
	//KitaoXVBł̓{[_Êݍs悤ɂ߃T`[V`FbN͕svɁB
	for (i = 0; i < nSamples; i++)
	{
		*pDst++ = (Sint16)((Sint32)(*pSrc) * _Volume / 65535); //KitaoXVBpSrĉقSint16ɂ̂ł̂܂܏ށB
		*pSrc++ = 0; //gIobt@0ɃNAĂ
		*pDst++ = (Sint16)((Sint32)(*pSrc) * _Volume / 65535);
		*pSrc++ = 0; //gIobt@0ɃNAĂ
	}

	//KitaoǉB̂Pobt@܂Ԃ܂Ńobt@f[^[ĂBv2.17XV
	//			 ōsƂŁAODirectSoundւ̏ݒɗ܂obt@g邱ƂɂȂAobt@Ȃݒ肵ĂۂĂB
	//			 ܂APSG̉𑜓xオ(DirectSound̃obt@ݏɃCXbhCPUPSGWX^邱ƂX̂)Aru[gȂǂ@̉ɋ߂ÂB
	//				   CPUG~[g̓4ubNɕčsĂ(MainBorad.cpp)ŔAőɐ߁B(ЂƂ̗R̓WCpbh͂̂Pt[x폜)
	//				   obt@̗ʂɂčČ኱ςA܂ɑPCɂȂƂɂ͂̌ʂoɂȂ\̂ŁÃ^C~OBv2.17L
	WaitForSingleObject(_hMutex, INFINITE); //CXbhɋLϐ\̂ŁArBv2.18
	switch (ch)
	{
		case 1: //PSG
			_NextPlayPos1 += _BufSize;
			if (_NextPlayPos1 == _BufSizeAll) _NextPlayPos1 = 0;
			//̂Pobt@܂Ԃ܂ŕ[
			if ((_MixBufPos1 >= _NextPlayPos1))
				a = _MixBufPos1 - _NextPlayPos1;
			else
				a = _BufSizeAll - _NextPlayPos1 + _MixBufPos1;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos1 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos1;
					PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n2);
					_MixBufPos1 = 0;
					n -= n2;
				}
				PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n);
				_MixBufPos1 += n;
				if (_MixBufPos1 >= _BufSizeAll)
					_MixBufPos1 -= _BufSizeAll;
				_MixBufEndPos1 = _MixBufPos1;
			}
			_bPosStop1 = FALSE;
			break;
			
		case 2: //ADPCM
			_NextPlayPos2 += _BufSize;
			if (_NextPlayPos2 == _BufSizeAll) _NextPlayPos2 = 0;
			//̂Pobt@܂Ԃ܂ŕ[
			if ((_MixBufPos2 >= _NextPlayPos2))
				a = _MixBufPos2 - _NextPlayPos2;
			else
				a = _BufSizeAll - _NextPlayPos2 + _MixBufPos2;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos2 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos2;
					ADPCM_Mix(_pMixBuf2+(_MixBufPos2 << 1), n2);
					_MixBufPos2 = 0;
					n -= n2;
				}
				ADPCM_Mix(_pMixBuf2+(_MixBufPos2 << 1), n);
				_MixBufPos2 += n;
				if (_MixBufPos2 >= _BufSizeAll)
					_MixBufPos2 -= _BufSizeAll;
				_MixBufEndPos2 = _MixBufPos2;
			}
			_bPosStop2 = FALSE;
			break;
		
		case 3: //CDDA
			_NextPlayPos3 += _BufSize;
			if (_NextPlayPos3 == _BufSizeAll) _NextPlayPos3 = 0;
			//̂Pobt@܂Ԃ܂ŕ[
			if ((_MixBufPos3 >= _NextPlayPos3))
				a = _MixBufPos3 - _NextPlayPos3;
			else
				a = _BufSizeAll - _NextPlayPos3 + _MixBufPos3;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos3 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos3;
					CDROM_Mix(_pMixBuf3+(_MixBufPos3 << 1), n2);
					_MixBufPos3 = 0;
					n -= n2;
				}
				CDROM_Mix(_pMixBuf3+(_MixBufPos3 << 1), n);
				_MixBufPos3 += n;
				if (_MixBufPos3 >= _BufSizeAll)
					_MixBufPos3 -= _BufSizeAll;
				_MixBufEndPos3 = _MixBufPos3;
			}
			break;
	}
	ReleaseMutex(_hMutex); //v2.18Br

	_bApuBusy = FALSE; //Kitaoǉ
}


//KitaoǉBR[obNXbhsȂTRUEԂBXe[gZ[uۂɎgpB
BOOL
APU_GetApuBusy()
{
	return _bApuBusy;
}


/*-----------------------------------------------------------------------------
	[Init]
		APU܂B
-----------------------------------------------------------------------------*/
BOOL
APU_Init(
	Uint32		sampleRate,
	Uint32		bufSize)		// in samples
{
	_hMutex = CreateMutex(NULL,FALSE,NULL); //v2.18

	_Volume				= 65535;

	_SampleRate			= sampleRate;
	_nSamplesPerFrame	= _SampleRate / 60;

	//obt@
	if (!APU_SetBufferSize(bufSize))
		return FALSE;

	PSG_Init(sampleRate);
	ADPCM_Init();

	return TRUE;
}


void
APU_Pause(
	BOOL		bPause)
{
	if (bPause)
		AOUT_Play(FALSE);
	else
		AOUT_Play(TRUE);
}


void
APU_Deinit()
{
	AOUT_Deinit(); //̌ĂяoAOUT̃Xbh͏IB
	PSG_Deinit();
	ADPCM_Deinit();
	if (_pMixBuf1 != NULL)
	{
		free(_pMixBuf1);
		_pMixBuf1 = NULL;
	}
	if (_pMixBuf2 != NULL)
	{
		free(_pMixBuf2);
		_pMixBuf2 = NULL;
	}
	if (_pMixBuf3 != NULL)
	{
		free(_pMixBuf3);
		_pMixBuf3 = NULL;
	}
	if (_hMutex != NULL)
	{
		CloseHandle(_hMutex); //v2.18
		_hMutex = NULL;
	}
}


BOOL
APU_Reset()
{
	//KitaoXVBAPU֘A̕ϐKviȂƃobt@̃|C^rn܂̂ŉxꍇj
	APU_Deinit();
	return APU_Init(_SampleRate, _BufSize);
}


/*-----------------------------------------------------------------------------
	[SetSampleRate]
-----------------------------------------------------------------------------*/
BOOL
APU_SetSampleRate(
	Uint32		sampleRate)
{
	AOUT_Deinit();

	ZeroMemory(_pMixBuf1, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	ZeroMemory(_pMixBuf2, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBADPCMp
	ZeroMemory(_pMixBuf3, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBCDDAp

	if (!AOUT_Init(APP_GetSoundType(), _BufSize, sampleRate, callback_mixer))
	{
		// ̐ݒɖ߂ 
		if (!AOUT_Init(APP_GetSoundType(), _BufSize, _SampleRate, callback_mixer))
			return FALSE;	// ł_Ȃ炠߂B
	}
	_SampleRate = sampleRate;
	_nSamplesPerFrame = _SampleRate / 60;

	PSG_SetSampleRate(sampleRate);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[SetBufferSize]
-----------------------------------------------------------------------------*/
//KitaoXVBʏ편s邱Ƃ͂Ȃ̂ŃVvɂB
BOOL
APU_SetBufferSize(
	Uint32		bufSize)
{
	AOUT_Deinit();

	if (APP_GetSoundMethod() == 20)
		_BufSize = bufSize/2 + bufSize/8; // Buffer1664(Defualt)1/2+1/8ŉœKBXAudio2p͒x(XAudiôpӂĂobt@)傫̂DirectSoundp̖񔼕̃obt@TCYłv(Œx͌݊pȏŗDG)Bv2.99
	else //DirectSound
		_BufSize = bufSize;

	if (_pMixBuf1 != NULL)
		free(_pMixBuf1);
	if (_pMixBuf2 != NULL)
		free(_pMixBuf2);
	if (_pMixBuf3 != NULL)
		free(_pMixBuf3);

	// 8 [byte/sample] for Sint32 stereo buffer 
	if ((_pMixBuf1 = (Sint16*)malloc(_BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
		return FALSE;
	if ((_pMixBuf2 = (Sint16*)malloc(_BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBADPCMp
		return FALSE;
	if ((_pMixBuf3 = (Sint16*)malloc(_BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBCDDAp
		return FALSE;

	ZeroMemory(_pMixBuf1, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	ZeroMemory(_pMixBuf2, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBADPCMp
	ZeroMemory(_pMixBuf3, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBCDDAp

	if (!AOUT_Init(APP_GetSoundType(), _BufSize, _SampleRate, callback_mixer))
		return FALSE;

	_BufSizeAll		= _BufSize * AOUT_BUFFERRATE; //Kitaoǉ
	_ClockCount		= 0;
	_MixBufPos1		= 0;
	_MixBufEndPos1	= 0.0;
	_NextPlayPos1	= 0; //Kitaoǉ
	_bPosStop1		= FALSE; //Kitaoǉ
	_bPosStop2		= FALSE; //Kitaoǉ
	_MixBufPos2		= 0;
	_MixBufEndPos2	= 0.0;
	_NextPlayPos2	= 0; //Kitaoǉ
	_MixBufPos3		= 0;
	_MixBufEndPos3	= 0;
	_NextPlayPos3	= 0; //Kitaoǉ
	AOUT_SetPlayStart(); //KitaoǉBĐ̍}ݒ肷B͂܂obt@ɂޗiPSGL[j܂ĂȂAOUT̂قŃEFCg悤ɂB

	return TRUE;
}


void
APU_SetVolume(
	Uint32		volume)		// 0 - 65535
{
	_Volume = volume;
}


#define DIV				256.0
#define DELTA_POS		44100.0 / 60.0 / DIV //KitaoǉB萔ɂB
#define DELTA_CLOCK		(Sint32)(2.0 * PSG_FRQ / 60.0 / DIV - 3.0) //KitaoǉB萔ɂBr؂̃v`mCYh߂-3.0iDELTA_POS̐؂グlԂB傫ƘA͗ǂȂ邪̂؂肵ɂȂjBv1.09XV

//KitaoXVBv2.32
void
APU_AdvanceClock()
{
	Sint32		nSamples;
	Sint32		nSamples2;//Kitaoǉ
//	Sint32		deltaClock; //KitaoXVB萔ɂđxAbvB
//	double		deltaPos; //KitaoXVB44100HzŒ̂ߒ萔ɂđxAbvB

	ADPCM_AdvanceFadeClock();
	CDROM_AdvanceFadeClock(); //Kitaoǉ

	if (++_ClockCount < DELTA_CLOCK)
		return;

	//WriteBuffer
	//  KitaoXVBobt@Sɕăobt@ɓr؂ʒuȂ悤ɂBx͂̂܂܂Ńobt@߂悤ɂȂ茋ʓIɉオB
	//			   i߂NbN1NbNŒɂB߂l͔p~B
	//			   v2.17XVBłPSG`l݂̂Mix邱ƂɂBCD-ROM̓Xg[Ȃ̂łׂ̍^C~OMixKvȂ߁BB

	_ClockCount = 0;

	WaitForSingleObject(_hMutex, INFINITE); //I[fBIXbhɋLϐ\̂ŁArBv2.18

	// KitaoXVBPSG, ADPCM, CDDA ꂼʃobt@ōĐ悤ɂB
	//i\tgPSG,ADPCM,CDDA~bNXĉ炵ꍇA_Ci~bNW1/3ɉȂĂ͂Ȃ̂ŉ傫Ă܂߁j

	// PSG`l
	if (!_bPosStop1)
	{
		_MixBufEndPos1 += DELTA_POS;
		nSamples = (Sint32)(_MixBufEndPos1 + 0.5) - _MixBufPos1; //_ȉ͎ľܓBPSG̏ꍇAMix^C~OmȂقǁA؂̂āE؂グǂȂB
		if (_MixBufPos1 + nSamples >= _BufSizeAll) //ŏI_߂Ȃ
		{
			nSamples2 = _BufSizeAll - _MixBufPos1;
			//E_܂ŏ
			PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples2);// XeI _MixBufPos*2
			_MixBufPos1 = 0;
			if (_NextPlayPos1 != 0) //̍Đ擪炶Ȃꍇ
			{
				//c擪珑
				nSamples -=	nSamples2;
				PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
				_MixBufPos1 = nSamples;
				_MixBufEndPos1 -= (double)_BufSizeAll;
			}
			else
			{
				//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
				_MixBufEndPos1 = 0.0;
				_bPosStop1 = TRUE;
			}
		}
		else if	((_MixBufPos1 < _NextPlayPos1)&&(_MixBufPos1 + nSamples >= _NextPlayPos1)) //ݕ_OŁAƕ_߂Ȃ
		{
			nSamples = _NextPlayPos1 - _MixBufPos1;
			//E_܂ŏ
			PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
			//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
			_MixBufPos1 = _NextPlayPos1;
			_MixBufEndPos1 = _MixBufPos1;
			_bPosStop1 = TRUE;
		}
		else //ʏ
		{
			PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
			_MixBufPos1 += nSamples;
		}
	}

	// ADPCM`l
	if (!_bPosStop2)
	{
		_MixBufEndPos2 += DELTA_POS;
		nSamples = (Sint32)(_MixBufEndPos2 + 0.5) - _MixBufPos2; //_ȉ͎ľܓBhSXC[pY`̃hōׂȃ^C~Ov邱Ƃ̂ŁA؎̂Đ؂グłȂľܓƂB
		if (_MixBufPos2 + nSamples >= _BufSizeAll) //ŏI_߂Ȃ
		{
			nSamples2 = _BufSizeAll - _MixBufPos2;
			//E_܂ŏ
			ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples2);// XeI _MixBufPos*2
			_MixBufPos2 = 0;
			if (_NextPlayPos2 != 0) //̍Đ擪炶Ȃꍇ
			{
				//c擪珑
				nSamples -=	nSamples2;
				ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);// XeI _MixBufPos*2 
				_MixBufPos2 = nSamples;
				_MixBufEndPos2 -= (double)_BufSizeAll;
			}
			else
			{
				//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
				_MixBufEndPos2 = 0.0;
				_bPosStop2 = TRUE;
			}
		}
		else if	((_MixBufPos2 < _NextPlayPos2)&&(_MixBufPos2 + nSamples >= _NextPlayPos2)) //ݕ_OŁAƕ_߂Ȃ
		{
			nSamples = _NextPlayPos2 - _MixBufPos2;
			//E_܂ŏ
			ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);// XeI _MixBufPos*2 
			//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
			_MixBufPos2 = _NextPlayPos2;
			_MixBufEndPos2 = _MixBufPos2;
			_bPosStop2 = TRUE;
		}
		else //ʏ
		{
			ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);// XeI _MixBufPos*2 
			_MixBufPos2 += nSamples;
		}
	}

	ReleaseMutex(_hMutex); //v2.18Br
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
APU_SaveState(
	FILE*		p)
{
	BOOL	ret;
	Sint32	windowsVolume;

	if (p == NULL)
		return FALSE;

	SAVE_V(_ClockCount);
	windowsVolume = APP_GetWindowsVolume();
	SAVE_V(windowsVolume); //v1.61ǉBQ[̃{[lBW[[ĥƂ̂ݗLB񃌃W[ɂSAVE͂ĂB

	ret =  PSG_SaveState(p);
	ret |= ADPCM_SaveState(p);
	
	return ret;
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
APU_LoadState(
	FILE*		p)
{
	BOOL	ret;
	Sint32	windowsVolume;

	if (p == NULL)
		return FALSE;

	LOAD_V(_ClockCount);
	if (MAINBOARD_GetStateVersion() >= 33) //KitaoǉBv1.61betaȍ~̃Z[ut@CȂ
	{
		LOAD_V(windowsVolume);
		APP_ResumeWindowsVolume(windowsVolume); //W[t@Cǂݏoꍇ̂݁Aʂ𕜌B
	}

	ret =  PSG_LoadState(p);
	ret |= ADPCM_LoadState(p);

	return TRUE;
}

#undef SAVE_V
#undef LOAD_V
